using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{

    public partial class VM
	{

        public VM()
        {
            Interfaces = new VmNetworkInterface[0];
        }

		public bool isStatusUp()
		{
			return isStatusUp(status);
		}

        public static bool isStatusUp(VMStatus st)
		{
			return (st == VMStatus.Up ||
					st == VMStatus.PoweredDown ||
					st == VMStatus.PoweringDown ||
					st == VMStatus.PoweringUp ||
					st == VMStatus.MigratingFrom ||
					st == VMStatus.WaitForLaunch ||
					st == VMStatus.RebootInProgress);

		}
		public static bool isStatusUpOrPaused(VMStatus st)
		{
			return (isStatusUp(st) ||
					st == VMStatus.Paused ||
					st == VMStatus.SavingState ||
					st == VMStatus.RestoringState);

		}
		public static bool isStatusQualifyToMigrate(VMStatus st)
		{
			return (st == VMStatus.Up ||
				   st == VMStatus.PoweringUp ||
				   st == VMStatus.Paused ||
                   st == VMStatus.RebootInProgress);
		}

		public static bool isStatusUpOrPausedOrSuspended(VMStatus st)
		{
			return (isStatusUpOrPaused(st) ||
					  st == VMStatus.Suspended);
		}

		public static bool isStatusDown(VMStatus st)
		{
			return (st == VMStatus.Down ||
					st == VMStatus.Suspended ||
					st == VMStatus.ImageLocked ||
					st == VMStatus.ImageIllegal);
		}
		public static bool isGuestUp(VMStatus st)
		{
			return (st == VMStatus.Up ||
					st == VMStatus.PoweringDown ||
				  st == VMStatus.PoweredDown ||
				  st == VMStatus.PoweringUp
				  );
		}

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }
            if (base.Equals(obj))
            {
                return true;
            }
            VM eq = obj as VM;
            if (eq != null)
            {
                if (eq.vm_guid == this.vm_guid)
                {
                    return true;
                }
            }
            return false;
        }
		/// <summary>
		/// Check if two Vms are Equal. Current equation rule is:
		/// Two Vms are equal when them points to same object or have same
		/// vm_guid property
		/// </summary>
		/// <param name="vm1"></param>
		/// <param name="vm2"></param>
		/// <returns></returns>
		public static bool operator ==(VM vm1, VM vm2)
		{
			if ((object.Equals(vm1, null)) && (object.Equals(vm2, null)))
			{
				return true;
			}
			else if (!object.Equals(vm1, null))
			{
				return vm1.Equals(vm2);
			}
			else
			{
				return false;
			}
		}
		public static bool operator !=(VM vm1, VM vm2)
		{
			return !(vm1 == vm2);
		}
		public override int GetHashCode()
		{
			return base.GetHashCode();
		}
	

        [XmlIgnoreAttribute]
		public override object QueryableId
		{
			get { return vm_guid; }
		}

    	private static readonly List<string> _vmProperties =
    		new List<string>
    		{
    			"vm_name",
    			"status",
    			"usage_cpu_percent",
    			"usage_mem_percent",
    			"usage_network_percent",
    			"run_on_vds",
    			"run_on_vds_name",
    			"vm_description",
    			"vds_group_id",
    			"vds_group_name",
    			"vm_ip",
    			"guest_cur_user_name",
    			"DiskSize",
    			"vm_os",
    			"num_of_monitors",
    			"RoundedElapsedTime",
    			"vm_mem_size_mb",
    			"vm_domain",
    			"dedicated_vm_for_vds",
    			"guest_requested_memory",
    			"is_stateless",
    			"is_initialized",
    			"display",
    			"display_type",
                "default_display_type",
    			"run_on_vds",
    			"app_list",
    			"time_zone",
    			"display_secure_port",
    			"IsConfigured",
    			"is_auto_suspend",
    			"auto_startup",
    			"display_ip",
    			"priority",
                "default_boot_sequence",
				"iso_path",
				"VmPoolId",
                "num_of_sockets",
                "cpu_per_socket",
				"vds_group_compatibility_version",
				"usb_policy",
				"vmt_guid",
				"vmt_name",
                "initrd_url",       
                "kernel_url",        
                "kernel_params",
                "VmPauseStatus",
                "CustomProperties",
                "MigrationSupport",
				"num_of_cpus",
                "MinAllocatedMem"                
    		};

        //,"DiskSize"
        [XmlIgnoreAttribute]
		public override List<string> ChangeablePropertiesList
		{
			get { return _vmProperties; }
		}

		
	}
}
